using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Text;
using Kz.GammaTech.Pkcs;
using Kz.GammaTech.Crypto.Parameters;
using Kz.GammaTech.Cms;
using Kz.GammaTech.Math;
using Kz.GammaTech.Asn1;
using Kz.GammaTech.Asn1.X509;
using Kz.GammaTech.Asn1.Pkcs;
using Kz.GammaTech.Crypto;
using Kz.GammaTech.Asn1.Utilities;
using Kz.GammaTech.Security;
using Kz.GammaTech.Asn1.Gamma;
using System.IO;
using System.Net;

//   PKCS10   
namespace pkcs10
{
    class Program
    {
        static void Main(string[] args)
        {
            IAsymmetricCipherKeyPairGenerator pGen = GeneratorUtilities.GetKeyPairGenerator("ECGOST3410");
            ECDomainParameters ecP = ECGost3410NamedCurves.GetByName("GostR3410-2001-Gamma-A");
            ECKeyGenerationParameters genParam = new ECKeyGenerationParameters(ecP, new SecureRandom());
            pGen.Init(genParam);
            AsymmetricCipherKeyPair pair = pGen.GenerateKeyPair();
            Hashtable attrs = new Hashtable();
            attrs.Add(X509Name.C, "KZ");
            attrs.Add(X509Name.O, "Gamma");
            attrs.Add(X509Name.L, "Almaty");
            attrs.Add(X509Name.ST, "User");
            attrs.Add(X509Name.EmailAddress, "gammat@gamma.kz");


            X509Name subject= new X509Name(new ArrayList(attrs.Keys), attrs);

            Asn1Set attr = MSTemplate.getASN1Template("c=KZ;o=template;cn=default"); //  

            Pkcs10CertificationRequest req1 = new Pkcs10CertificationRequest(
              "GOST3411withECGOST3410",
                subject,
                pair.Public,
                attr,
                pair.Private);

            byte[] bytes = req1.GetEncoded();
            FileInfo f = new FileInfo(@"req.bin");
            FileStream file = f.Create();
            file.Write(bytes, 0, bytes.Length);
            file.Close();

            Pkcs10CertificationRequest req2 = new Pkcs10CertificationRequest(bytes);

            if (!req2.Verify())
            {
                Console.WriteLine("Failed verify check.");
            }
            else
            {

                string temp_out = MSTemplate.getTemplateName(req2.GetCertificationRequestInfo().Attributes); //   
                Console.WriteLine(temp_out);
                Console.WriteLine("Success");
            }
   }
}